package gov.va.genisis2.bs.service;

import java.util.List;

import gov.va.genisis2.ts.common.dto.BookmarkDTO;
import gov.va.genisis2.ts.common.dto.LabelDTO;

/**
 * Contract for Bookmark Service calls
 * @author PII
 */
public interface IBusinessService {
	public List<BookmarkDTO> getBookmarks();

	public BookmarkDTO createBookmark(BookmarkDTO bookmarkDto);
	public void deleteBookmark(Integer id);
	
	public BookmarkDTO labelBookmark(LabelDTO labelDto);
	
	public BookmarkDTO unlabelBookmark(LabelDTO labelDto);
	
	public List<BookmarkDTO> fetchAllBookmarksByUsername(String username);

	public List<LabelDTO> fetchAllLabelsByUsername(String username);

	public List<BookmarkDTO> fetchAllBookmarksByLabel(String label);
	
//	public BookmarkDTO getBookmark(Integer id);
	
}
